DECLARE @Script NVARCHAR(max)
='   PROCEDURE [dbo].[usp_CRDT_Load_T2BaseList] 
	@T3Id	INT ,
	@LevelId INT , -- ([Level] of T2B)
	@ParentId INT -- NOT need
	,@Etc SQL_VARIANT = 0 -- 
AS
BEGIN
	SET NOCOUNT ON
	IF (ISNULL(@Etc,0) <> 0)
		BEGIN
			DECLARE @EtcId BIGINT
			SELECT @EtcId = CAST(@Etc AS BIGINT)
			IF (@EtcId = 1)
				SELECT * FROM dbo.CRDT_T2Base WHERE (Id < 200)
			ELSE
				SELECT * FROM dbo.CRDT_T2Base WHERE (Id >= (@EtcId*100) AND Id < ((@EtcId+1)*100)) 
		END
	ELSE
		BEGIN
			SELECT 
				 T2Base.Id
				,T2Base.Code
				,T2Base.[Name]
				,[Level]
				,@T3Id AS T3Id 
				,CAST (1 AS BIT) AS CreatedForEvery
				,T2Base.StemFLG
				,CASE T2Base.StemFLG WHEN 0 THEN ''غیر سیستمی'' ELSE ''سیستمی'' END AS SystemType
				,CASE T2Base.StemFLG WHEN 2 THEN ''مشخصات منابع'' ELSE ''برنامه / طرح'' END AS Type
				,Income.Code AS IncomeCode
				,Income.[Name] AS IncomeName
				,Income.Id AS IncomeId
				,(select T2B.Name from CRDT_T2Base AS T2B where T2B.Id = T2Base.ParentId) AS ParentName
				,T2Base.ParentId AS ParentId
			FROM dbo.CRDT_T2Base T2Base
			LEFT JOIN dbo.ACC_IncomeType Income
			ON T2Base.IncomeId=income.Id
			WHERE 
					T2Base.T3Id IS NULL
				AND 
					T2Base.[Level]= @LevelId
			UNION ALL
			SELECT     
				 T2Base.Id
				,T2Base.Code
				,T2Base.[Name]
				,T2Base.[Level]
				,@T3Id AS T3Id 
				,CAST (0 AS BIT) AS CreatedForEvery
				,T2Base.StemFLG
			    ,CASE T2Base.StemFLG WHEN 0 THEN ''غیر سیستمی'' ELSE ''سیستمی'' END AS SystemType
			    ,CASE T2Base.StemFLG WHEN 2 THEN ''مشخصات منابع'' ELSE ''برنامه / طرح'' END AS Type
			    ,Income.Code AS IncomeCode
				,Income.[Name] AS IncomeName
				,Income.Id AS IncomeId
			    ,(select T2B.Name from CRDT_T2Base AS T2B where T2B.Id = T2Base.ParentId) AS ParentName
				,T2Base.ParentId AS ParentId
			FROM dbo.CRDT_T2Base t2base
			LEFT JOIN dbo.ACC_IncomeType income
			ON t2base.IncomeId=Income.Id
			WHERE
					T3Id = @T3Id
				AND 
					[Level]=@LevelId 
				AND 
					T2Base.Code NOT IN (SELECT Code FROM dbo.CRDT_T2Base WHERE (T3Id IS NULL) AND [Level]= @LevelId)
			ORDER BY T2Base.Id desc
		END
END

'
IF EXISTS (SELECT * FROM sys.objects WHERE name='usp_CRDT_Load_T2BaseList')
	SET @Script=' alter  '+ @Script
ELSE 
	SET @Script=' create  ' +@Script

	EXEC(@Script)