DECLARE @Script NVARCHAR(max)
='
  PROCEDURE [dbo].[usp_CRDT_Save_T2]
		@UserId INT, -- 
		@Id	INT,			
		@T2MId INT,
		@T2DCode CHAR(2) =''90'',	
		@T2RId INT,
		@T2BId INT,
		@T2RHId INT,
		@T3Id INT	,
		@T2FCode CHAR(2)='''',
		@T2AZId INT = NULL,
		@RankNumberId INT = NULL,
		@T3OwnerId INT,
		@TAFValue BIGINT,
		@CreateActiveYear TINYINT,
		@T2MasterId INT,
		@SelectAndReturnData BIT = 1,
		@ResultId INT = -1 OUTPUT,
		@Active BIT = 1,
		@ControlCode INT = 0
AS
BEGIN

  
	SET NOCOUNT ON
	DECLARE @FindedByDetail BIT
	SET @FindedByDetail = 0
	IF (@T3Id IS NULL OR @T3Id < 1) EXEC dbo.usp_None_Load_RAISERROR N''SP_CRDT_ST2_ERR2145: مركز شناسائی نشده است''
	IF (@T3OwnerId IS NULL OR @T3OwnerId < 1) SELECT @T3OwnerId = SetadId FROM dbo.M_ORG_T3 WHERE Id = @T3Id
	IF (@T2RHId < 1) SET @T2RHId = NULL
	IF (@T2AZId < 1) SET @T2AZId = NULL
	IF (@RankNumberId < 1) SET @RankNumberId = NULL
	IF (ISNULL(@UserId,0) < 1)
		SELECT @UserId = MIN(Id) FROM dbo.ORG_Personnel WHERE T3Id = @T3OwnerId
	 
	 
	 DECLARE @final BIT, @finalbyuser BIT
	 SELECT @final = final,  @finalbyuser = FinalByUser
	 FROM dbo.ACC_YEARS y 
	 WHERE y.t3id=@T3Id AND y.[year]=@CreateActiveYear
	 
	 
	 IF ( @final=1 AND @finalbyuser=1)
		BEGIN
			EXEC dbo.usp_None_Load_RAISERROR N''سال مالی انتخابی توسط سیستم و کاربر نهایی شده است''
			RETURN;
		END
		
		IF ( @final=1 AND @finalbyuser=0)
		BEGIN
			EXEC dbo.usp_None_Load_RAISERROR N''سال مالی انتخابی نهایی شده است''
			RETURN;
		END
		 
		 
	IF ( @final=0 AND @finalbyuser=1) 
	BEGIN
		EXEC dbo.usp_None_Load_RAISERROR N''سال مالی انتخابی توسط کاربر نهایی شده است''
		RETURN;
	END
		
	IF (@CreateActiveYear > 94 AND CAST(@T2DCode AS INT)> 94)
	BEGIN
	 
	 DECLARE @T2MCode VARCHAR(20),@StemFLG TINYINT
	 SELECT @T2MCode= code FROM dbo.CRDT_T2Base WHERE Id=@T2MId
	 SELECT @StemFLG = StemFLG FROM dbo.CRDT_T2Base WHERE Id=@T2BId
	 IF (@T2MCode NOT IN (''21'',''22'') AND @StemFLG=0 )
	  BEGIN
	   EXEC dbo.usp_None_Load_RAISERROR N''شما مجاز به استفاده از این برنامه نیستید ''
	   RETURN;
	  END
	 
	END
		
	IF (@T3Id <> @T3OwnerId)-- AND (@T2MasterId = -500 OR @T2MasterId = @Id))
		BEGIN
		
  
		 
			SELECT @T2MasterId = [dbo].[UF_CRDT_FINDT2IdByT2Bases] (@T2MId,@T2DCode,@T2RId,@T2BId,@T2RHId,@T2FCode,@T2AZId,@RankNumberId,@T3OwnerId)
			IF (@T2MasterId IS NULL)	
				BEGIN 
					EXEC [dbo].[usp_CRDT_Save_T2] 
						 @UserId = @UserId
						,@Id = -1
						,@T2MId = @T2MId
						,@T2DCode = @T2DCode
						,@T2RId = @T2RId
						,@T2BId = @T2BId
						,@T2RHId = @T2RHId
						,@T3Id = @T3OwnerId
						,@T2FCode = @T2FCode
						,@T2AZId = @T2AZId
						,@RankNumberId = @RankNumberId
						,@T3OwnerId = @T3OwnerId
						,@TAFValue = 0
						,@CreateActiveYear = @CreateActiveYear
						,@T2MasterId = -1
						,@SelectAndReturnData = 0
						,@ResultId  = @T2MasterId OUTPUT
						,@ControlCode = @ControlCode
				END
		END
	ELSE IF @T2MasterId < 1 
		SET @T2MasterId = NULL
	IF (@Id < 1 AND @T2MasterId IS NOT NULL)
		BEGIN
			SELECT @Id = [dbo].[UF_CRDT_FINDT2IdByT2Bases] (@T2MId,@T2DCode,@T2RId,@T2BId,@T2RHId,@T2FCode,@T2AZId,@RankNumberId,@T3Id)
			IF @Id > 0 SET @FindedByDetail = 1
		END
		
	IF(ISNULL(@Id,0) < 1)
		BEGIN
		

		
	
		
		 INSERT INTO [dbo].[CRDT_T2]
				   ([T2MId]
				   ,[T2DCode]
				   ,[T2RId]
				   ,[T2BId]
				   ,[T2RHId]
				   ,[Value]
				   ,[T3Id]
				   ,[T2FCode]
				   ,[T2AZId]
				   ,[RankNumberId]
				   ,[T3OwnerId]
				   ,T2MasterId
				   ,TAFValue
				   ,CreateActiveYear
				   ,LastEditorId
				   ,ControlCode)
				VALUES
				   (@T2MId
				   ,@T2DCode
				   ,@T2RId
				   ,@T2BId
				   ,@T2RHId
				   ,0
				   ,@T3Id
				   ,@T2FCode
				   ,@T2AZId
				   ,@RankNumberId
				   ,@T3OwnerId
				   ,@T2MasterId
				   ,@TAFValue					   
				   ,@CreateActiveYear
				   ,@UserId
				   ,@ControlCode)
			SET @Id = SCOPE_IDENTITY();
			IF (@T3Id = @T3OwnerId)
			BEGIN
				IF (@T2MasterId IS NULL)
					UPDATE [dbo].[CRDT_T2] SET T2MasterId = @Id WHERE Id = @Id
				--IF (@TAFValue = 0)
				--	BEGIN
				--		EXEC [dbo].[usp_PUB_Save_CacheDataForIdOfObject] 36,@T3Id,1,-100,@Id -- TRG DONT Caled bec of Value = 0
				--		EXEC [dbo].[usp_PUB_Save_CacheData] 36,@T3Id,0,-100			 -- TRG DONT Caled bec of Value = 0				
				--	END
			 END
			
		END
	ELSE
		BEGIN
			DECLARE @Used BIT
			IF @FindedByDetail = 1
				SET @Used = 0
			ELSE
				BEGIN
					IF EXISTS (SELECT * FROM dbo.ACC_AccDocRow WHERE T2Id = @Id)
						BEGIN 
							IF EXISTS (
										SELECT * FROM [dbo].[CRDT_T2] WHERE 
											  Id = @Id 
										  AND [T2MId] = @T2MId
										  AND [T2DCode] = @T2DCode
										  AND [T2RId] = @T2RId
										  AND [T2BId] = @T2BId
										  AND ISNULL([T2RHId],0) = ISNULL(@T2RHId,0)
										  AND ISNULL([T2FCode],''n'') = ISNULL(@T2FCode,''n'')
										  AND ISNULL([T2AZId],0) = ISNULL(@T2AZId,0)
										  AND ISNULL([RankNumberId],0) = ISNULL(@RankNumberId,0)
										  AND [T3OwnerId] = @T3OwnerId
										  --AND 
												--(
												--	[T3Id] <> @T3Id
												--OR
												--	[TAFValue] <> @TAFValue
												--OR
												--	[T2MasterId] <> @T2MasterId
												--)
										)
								SET @Used = 0 -- مجوز ويرايش مبلغ تفاهم نامه بدون داشتن مجوز ويرايش کدهاي استفاده شده
							ELSE
								SET @Used = 1
						END
					ELSE
						SET @Used = 0
					
					IF (@Used = 1 AND EXISTS (SELECT * FROM [dbo].[CRDT_T2] WHERE Id = @Id AND T2MasterId <> @Id))
						BEGIN
							EXEC dbo.usp_None_Load_RAISERROR N''از کد مورد نظر شما در اسناد واحد تابعه استفاده شده است، براي ويرايش اطلاعات اجزاي آن، کد معادل با شناسه ي ستاد را ويرايش کنيد.
''
							RETURN;
						END
					DECLARE @PMLs VARCHAR(MAX)
					IF (@Used = 1)
						BEGIN
							SELECT @PMLs = '',,''+PMA+'','' FROM dbo.ORG_Personnel WHERE Id = @UserId
							IF  (@PMLs IS NOT NULL AND CHARINDEX('',288,'', @PMLs) > 0)
								SET @Used = 0
						END
				END	
			IF (@Used = 0)
				BEGIN
					UPDATE [dbo].[CRDT_T2]
						SET	   [T2MId] = @T2MId
							  ,[T2DCode] = @T2DCode
							  ,[T2RId] = @T2RId
							  ,[T2BId] = @T2BId
							  ,[T2RHId] = @T2RHId
							  --,[T3Id] = CASE WHEN Id = @Id THEN @T3Id ELSE [T3Id] END 
							  ,[T2FCode] = @T2FCode
							  ,[T2AZId] = @T2AZId
							  ,[RankNumberId] = @RankNumberId
							  ,[T3OwnerId] = CASE WHEN Id = @Id THEN @T3OwnerId ELSE [T3OwnerId] END 
							  ,[T2MasterId] = CASE WHEN Id = @Id THEN @T2MasterId ELSE [T2MasterId] END  
							  ,[TAFValue] = CASE WHEN Id = @Id THEN @TAFValue ELSE [TAFValue] END  						  
							  ,[CreateActiveYear] = @CreateActiveYear
							  ,[LastEditorId] = @UserId
							  ,[Active] = CASE WHEN Id = @Id THEN @Active ELSE [Active] END  
							  ,[ControlCode] = @ControlCode
						WHERE Id = @Id OR T2MasterId = @Id
				END
			ELSE
				BEGIN
					EXEC dbo.usp_None_Load_RAISERROR N''از کد مورد نظر شما در اسناد استفاده شده و شما مجوز ويرايش کدهاي استفاده شده را نداريد''
					RETURN;
				END
		END
	IF (@SelectAndReturnData = 1)
		SELECT * FROM dbo.UV_CRDT_T2 WHERE Id = @Id;
	ELSE 
		SET @ResultId = @Id;
END

 
            


 
            


'
IF EXISTS (SELECT * FROM sys.objects WHERE name='usp_CRDT_Save_T2')
	SET @Script=' alter  '+ @Script
ELSE 
	SET @Script=' create  ' +@Script

	EXEC(@Script)